#include "stdafx.h"
#include "GVector.h"
#include "GException.h"

//=======================================================
//              GVector Definition
//=======================================================


//inline Functions---------------------------------------
inline void GVector::allocGVector()
{
	_data.clear();
	_data=vector<double>(_nbElements);
     for (  int i = 0; i <_nbElements; i++)
		_data[i] = 0;
}

inline void GVector::desallocGVector()
{
	_data.clear();
}

inline void GVector::getVector(const GVector& vect)
{
	for (  int i = 0; i <_nbElements; i++)
		_data[i] = vect._data[i];
}

//Constructors and destructors---------------------------
GVector::GVector()
{
	_data.clear();
	_nbElements=0;
	
}

GVector::GVector(  int size)
{
	_data.clear();
	_nbElements = size;
	allocGVector();
}

GVector::GVector(const GVector& vect)
{
	_data.clear();
	_nbElements = vect._nbElements;
	this->allocGVector();
	this->getVector(vect);
}



GVector::~GVector()
{
	this->desallocGVector();
}

//other methods------------------------------------------
  int GVector::size() const
{
	return _nbElements;
}


double GVector::getNorm() const
{
	double res = 0;
	for (  int i=0; i<_nbElements; i++)
		res += _data[i]*_data[i];
	return sqrt(res);
}



void GVector::initWithValue(double value)
{
	for (  int i=0; i<_nbElements; i++)
		_data[i] = value;
}


//operators----------------------------------------------
GVector& GVector::operator = (const GVector& vect)
{
	_nbElements = vect._nbElements;
	this->allocGVector();
	this->getVector(vect);
	return *this;
}



GVector& GVector::operator += (const GVector& vect)
{   
    if (vect._nbElements != _nbElements)
		 throw (GException("GVector","GVector& GVector::operator += (const GVector& vect)","vectors with different sizes"));
	for (  int i=0; i< _nbElements; i++)
	{
		_data[i]+=vect._data[i];
	}
	return *this;
}

GVector& GVector::operator -= (const GVector& vect)
{
	if (vect._nbElements != _nbElements)
		 throw (GException("GVector","GVector& GVector::operator -= (const GVector& vect)","vectors with different sizes"));
	for (  int i=0; i< _nbElements; i++)
	{
		_data[i]-=vect._data[i];
	}
	return *this;
}


GVector& GVector::operator *= (const double& v)
{
	for (  int i=0; i< _nbElements; i++)
		_data[i]*=v;
	return *this;
}

GVector GVector::operator + ()
{
	return *this;
}

GVector GVector::operator - ()
{
	GVector res = GVector(_nbElements);
	for (  int i=0; i<_nbElements;i++)
		res._data[i]=-_data[i];
	return res;
}

double GVector::operator ! ()
{
	double res = 0.0;
	for (  int i=0; i<_nbElements; i++)
		res += _data[i]*_data[i]; 
	return sqrt(res);
}

GVector operator + (const GVector& vect1, const GVector& vect2)
{   
	if (vect1._nbElements != vect2._nbElements)
		 throw (GException("GVector","GVector operator + (const GVector& vect1, const GVector& vect2)","vectors with different sizes"));
	GVector res(vect1._nbElements);res = vect1; res +=vect2;
	return res;
}

GVector operator - (const GVector& vect1, const GVector& vect2)
{
	if (vect1._nbElements != vect2._nbElements)
		 throw (GException("GVector","GVector operator - (const GVector& vect1, const GVector& vect2)","vectors with different sizes"));
	GVector res(vect1._nbElements); res = vect1; res -=vect2;
	return res;
}


double operator * (const GVector& vect1, const GVector& vect2)
{
	if (vect1._nbElements != vect2._nbElements)
		 throw (GException("GVector","double operator * (const GVector& vect1, const GVector& vect2)","vectors with different sizes"));
	double res=0;
	for (  int i=0; i<vect1._nbElements;i++)
        res += vect1._data[i] * vect2._data[i];
	return res;
}

GVector operator * (const double& v, const GVector& vect)
{
	GVector res(vect._nbElements); res=vect; res*=v;
	return res;
}

GVector operator * (const GVector& vect, const double& v)
{
	return v*vect;
}

GVector operator / (const GVector& vect, const double& v)
{
	
	if (v!=0) return (vect* (1.0 / v));
	else {
		return vect;
		throw (GException("GVector","GVector operator / (const GVector& vect, const double& v)","division by Zero"));
	}
}

ostream& operator << (ostream& out,GVector vect)
{
	for (  int i=1; i<=vect.size(); i++)
		out<<vect(i)<<"\n";
	out<<endl;
	return out;
}







